/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package applicationIO;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class ConsoleOutput implements Output {
    StringBuilder buffer = new StringBuilder();
    
    //The write and writeln methods simply add the content to the temporary buffer
    //The close and flush methods will then sent the output to the screen.
    //You must call the close or flush methods in order to see the output.
    public void write(String input){
        buffer.append(input);
    };
    public void writeln(String input){
        buffer.append(input);
        buffer.append('\n');
    };
    
    public void close(){
        System.out.println(buffer);
        //Create a fresh buffer for next time
        StringBuilder buffer = new StringBuilder();
    }

}
